/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package data.structures.tagging;

import java.util.Set;
import java.util.Vector;

public class GraphLemmaItem {
    private Integer nodeID;
    private String nodeName;
    private Set<GraphLemmaItem> childs, parents;
    private Set<LemmaItem> lemmas;

    public void setNodeID(Integer i){
        nodeID=i;
    }
    public void setNodeName(String s){
        nodeName=s;
    }
    public void setParents(Set<GraphLemmaItem> parentNodes){
        parents=parentNodes;
    }
    public void setChilds(Set<GraphLemmaItem> childNodes){
        childs=childNodes;
    }
    public void setLemmas(Set<LemmaItem> l){
        lemmas = l;
    }

    public int getNodeID(){
        return nodeID;
    }
    public String getNodeName(){
        return nodeName;
    }
    public Set<GraphLemmaItem> getParents(){
        return parents;
    }
    public Set<GraphLemmaItem> getChilds(){
        return childs;
    }
    public Set<LemmaItem> getLemmas(){
        return lemmas;
    }

    public String[] getLemmasAsStrings(){
        String[] result = new String[lemmas.size()];
        Vector<LemmaItem> v = new Vector<LemmaItem>(lemmas);
        for(int i=0; i<result.length; i++){
            result[i] = v.elementAt(i).getLemmaName();
        }
        return result;
    }
}
